/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.RenderMaterialImpl;
import link.infra.indium.renderer.helper.ColorHelper;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MeshImpl;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.MatrixRenderContext;
import link.infra.indium.renderer.render.VertexConsumerQuadBufferer;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_325;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class ItemRenderContext
extends MatrixRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final class_325 colorMap;
    private final class_5819 random = class_5819.method_43047();
    private final class_1160 normalVec = new class_1160();
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private final Maker editorQuad = new Maker();
    private final MeshConsumer meshConsumer = new MeshConsumer();
    private final FallbackConsumer fallbackConsumer = new FallbackConsumer();
    private class_1799 itemStack;
    private class_809.class_811 transformMode;
    private class_4587 matrixStack;
    private class_4597 vertexConsumerProvider;
    private int lightmap;
    private VanillaQuadHandler vanillaHandler;
    private boolean isDefaultTranslucent;
    private boolean isTranslucentDirect;
    private class_4588 translucentVertexConsumer;
    private class_4588 cutoutVertexConsumer;
    private class_4588 modelVertexConsumer;

    public ItemRenderContext(class_325 colorMap) {
        this.colorMap = colorMap;
    }

    public void renderModel(class_1799 itemStack, class_809.class_811 transformMode, boolean invert, class_4587 matrixStack, class_4597 vertexConsumerProvider, int lightmap, int overlay, class_1087 model, VanillaQuadHandler vanillaHandler) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.vanillaHandler = vanillaHandler;
        this.computeOutputInfo();
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        ((FabricBakedModel)model).emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        this.itemStack = null;
        this.matrixStack = null;
        this.vanillaHandler = null;
        this.translucentVertexConsumer = null;
        this.cutoutVertexConsumer = null;
        this.modelVertexConsumer = null;
    }

    private void computeOutputInfo() {
        this.isDefaultTranslucent = true;
        this.isTranslucentDirect = true;
        class_1792 item = this.itemStack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2680 state = blockItem.method_7711().method_9564();
            class_1921 renderLayer = class_4696.method_23679((class_2680)state);
            if (renderLayer != class_1921.method_23583()) {
                this.isDefaultTranslucent = false;
            }
            if (this.transformMode != class_809.class_811.field_4317 && !this.transformMode.method_29998()) {
                this.isTranslucentDirect = false;
            }
        }
        this.modelVertexConsumer = this.quadVertexConsumer(BlendMode.DEFAULT);
    }

    private class_4588 quadVertexConsumer(BlendMode blendMode) {
        boolean translucent;
        if (blendMode == BlendMode.DEFAULT) {
            translucent = this.isDefaultTranslucent;
        } else {
            boolean bl = translucent = blendMode == BlendMode.TRANSLUCENT;
        }
        if (translucent) {
            if (this.translucentVertexConsumer == null) {
                this.translucentVertexConsumer = this.isTranslucentDirect ? class_918.method_29711((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_24076(), (boolean)true, (boolean)this.itemStack.method_7958()) : (class_310.method_29611() ? class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_29382(), (boolean)true, (boolean)this.itemStack.method_7958()) : class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_24076(), (boolean)true, (boolean)this.itemStack.method_7958()));
            }
            return this.translucentVertexConsumer;
        }
        if (this.cutoutVertexConsumer == null) {
            this.cutoutVertexConsumer = class_918.method_29711((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_24074(), (boolean)true, (boolean)this.itemStack.method_7958());
        }
        return this.cutoutVertexConsumer;
    }

    private void bufferQuad(MutableQuadViewImpl quad, BlendMode blendMode) {
        VertexConsumerQuadBufferer.bufferQuad(this.quadVertexConsumer(blendMode), quad, this.matrix, this.overlay, this.normalMatrix, this.normalVec);
    }

    private void colorizeQuad(MutableQuadViewImpl q, int colorIndex) {
        if (colorIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int itemColor = 0xFF000000 | this.colorMap.method_1704(this.itemStack, colorIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColor(itemColor, q.spriteColor(i, 0))));
            }
        }
    }

    private void renderQuad(MutableQuadViewImpl quad, BlendMode blendMode, int colorIndex) {
        this.colorizeQuad(quad, colorIndex);
        int lightmap = this.lightmap;
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
        }
        this.bufferQuad(quad, blendMode);
    }

    private void renderQuadEmissive(MutableQuadViewImpl quad, BlendMode blendMode, int colorIndex) {
        this.colorizeQuad(quad, colorIndex);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(quad, blendMode);
    }

    private void renderMeshQuad(MutableQuadViewImpl quad) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        RenderMaterialImpl.Value mat = quad.material();
        int colorIndex = mat.disableColorIndex(0) ? -1 : quad.colorIndex();
        BlendMode blendMode = mat.blendMode(0);
        if (mat.emissive(0)) {
            this.renderQuadEmissive(quad, blendMode, colorIndex);
        } else {
            this.renderQuad(quad, blendMode, colorIndex);
        }
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        public Maker emit() {
            this.computeGeometry();
            ItemRenderContext.this.renderMeshQuad(this);
            this.clear();
            return this;
        }
    }

    private class MeshConsumer
    implements Consumer<Mesh> {
        private MeshConsumer() {
        }

        @Override
        public void accept(Mesh mesh) {
            MeshImpl m = (MeshImpl)mesh;
            int[] data = m.data();
            int limit = data.length;
            for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
                System.arraycopy(data, index, ItemRenderContext.this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
                ItemRenderContext.this.editorQuad.load();
                ItemRenderContext.this.renderMeshQuad(ItemRenderContext.this.editorQuad);
            }
        }
    }

    private class FallbackConsumer
    implements Consumer<class_1087> {
        private FallbackConsumer() {
        }

        @Override
        public void accept(class_1087 model) {
            if (ItemRenderContext.this.hasTransform()) {
                for (int i = 0; i <= 6; ++i) {
                    class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
                    ItemRenderContext.this.random.method_43052(42L);
                    List quads = model.method_4707(null, cullFace, ItemRenderContext.this.random);
                    int count = quads.size();
                    if (count == 0) continue;
                    for (int j = 0; j < count; ++j) {
                        class_777 q = (class_777)quads.get(j);
                        this.renderQuadWithTransform(q, cullFace);
                    }
                }
            } else {
                ItemRenderContext.this.vanillaHandler.accept(model, ItemRenderContext.this.itemStack, ItemRenderContext.this.lightmap, ItemRenderContext.this.overlay, ItemRenderContext.this.matrixStack, ItemRenderContext.this.modelVertexConsumer);
            }
        }

        private void renderQuadWithTransform(class_777 quad, class_2350 cullFace) {
            Maker editorQuad = ItemRenderContext.this.editorQuad;
            editorQuad.fromVanilla(quad, IndiumRenderer.MATERIAL_STANDARD, cullFace);
            if (!ItemRenderContext.this.transform((MutableQuadView)editorQuad)) {
                return;
            }
            ItemRenderContext.this.renderQuad(editorQuad, BlendMode.DEFAULT, editorQuad.colorIndex());
        }
    }

    @FunctionalInterface
    public static interface VanillaQuadHandler {
        public void accept(class_1087 var1, class_1799 var2, int var3, int var4, class_4587 var5, class_4588 var6);
    }
}

